/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;
import sun.reflect.misc.ReflectUtil;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static boolean disableSerialConstructorChecks = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String string = "jdk.disableSerialConstructorChecks";
            return "true".equals(System.getProperty(string)) ? Boolean.TRUE : Boolean.FALSE;
        }
    });
    private static final ReflectionFactory reflFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    private Class<?> cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private ExceptionInfo deserializeEx;
    private ExceptionInfo serializeEx;
    private ExceptionInfo defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor<?> cons;
    private ProtectionDomain[] domains;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;
    private boolean initialized;

    private static native void initNative();

    public static ObjectStreamClass lookup(Class<?> clazz) {
        return ObjectStreamClass.lookup(clazz, false);
    }

    public static ObjectStreamClass lookupAny(Class<?> clazz) {
        return ObjectStreamClass.lookup(clazz, true);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            this.suid = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl);
                }
            });
        }
        return this.suid;
    }

    @CallerSensitive
    public Class<?> forClass() {
        Class<?> clazz;
        if (this.cl == null) {
            return null;
        }
        this.requireInitialized();
        if (System.getSecurityManager() != null && ReflectUtil.needsPackageAccessCheck((clazz = Reflection.getCallerClass()).getClassLoader(), this.cl.getClassLoader())) {
            ReflectUtil.checkPackageAccess(this.cl);
        }
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String string) {
        return this.getField(string, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    static ObjectStreamClass lookup(Class<?> clazz, boolean bl) {
        if (!bl && !Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        ObjectStreamClass.processQueue(Caches.localDescsQueue, Caches.localDescs);
        WeakClassKey weakClassKey = new WeakClassKey(clazz, Caches.localDescsQueue);
        Reference reference = (Reference)Caches.localDescs.get(weakClassKey);
        Object object = null;
        if (reference != null) {
            object = reference.get();
        }
        EntryFuture entryFuture = null;
        if (object == null) {
            EntryFuture entryFuture2 = new EntryFuture();
            SoftReference<EntryFuture> softReference = new SoftReference<EntryFuture>(entryFuture2);
            do {
                if (reference != null) {
                    Caches.localDescs.remove(weakClassKey, reference);
                }
                if ((reference = (Reference)Caches.localDescs.putIfAbsent(weakClassKey, softReference)) == null) continue;
                object = reference.get();
            } while (reference != null && object == null);
            if (object == null) {
                entryFuture = entryFuture2;
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof EntryFuture) {
            entryFuture = (EntryFuture)object;
            object = entryFuture.getOwner() == Thread.currentThread() ? null : entryFuture.get();
        }
        if (object == null) {
            try {
                object = new ObjectStreamClass(clazz);
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            if (entryFuture.set(object)) {
                Caches.localDescs.put(weakClassKey, new SoftReference<Object>(object));
            } else {
                object = entryFuture.get();
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private ObjectStreamClass(final Class<?> clazz) {
        this.cl = clazz;
        this.name = clazz.getName();
        this.isProxy = Proxy.isProxyClass(clazz);
        this.isEnum = Enum.class.isAssignableFrom(clazz);
        this.serializable = Serializable.class.isAssignableFrom(clazz);
        this.externalizable = Externalizable.class.isAssignableFrom(clazz);
        Class<?> clazz2 = clazz.getSuperclass();
        this.superDesc = clazz2 != null ? ObjectStreamClass.lookup(clazz2, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (ObjectStreamClass.this.isEnum) {
                        ObjectStreamClass.this.suid = 0L;
                        ObjectStreamClass.access$602(ObjectStreamClass.this, NO_FIELDS);
                        return null;
                    }
                    if (clazz.isArray()) {
                        ObjectStreamClass.access$602(ObjectStreamClass.this, NO_FIELDS);
                        return null;
                    }
                    ObjectStreamClass.this.suid = ObjectStreamClass.getDeclaredSUID(clazz);
                    try {
                        ObjectStreamClass.access$602(ObjectStreamClass.this, ObjectStreamClass.getSerialFields(clazz));
                        ObjectStreamClass.this.computeFieldOffsets();
                    }
                    catch (InvalidClassException invalidClassException) {
                        ObjectStreamClass.this.serializeEx = (ObjectStreamClass.this.deserializeEx = new ExceptionInfo(invalidClassException.classname, invalidClassException.getMessage()));
                        ObjectStreamClass.access$602(ObjectStreamClass.this, NO_FIELDS);
                    }
                    if (ObjectStreamClass.this.externalizable) {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(clazz);
                    } else {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getSerializableConstructor(clazz);
                        ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                        ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                        ObjectStreamClass.this.readObjectNoDataMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObjectNoData", null, Void.TYPE);
                        ObjectStreamClass.this.hasWriteObjectData = ObjectStreamClass.this.writeObjectMethod != null;
                    }
                    ObjectStreamClass.access$2102(ObjectStreamClass.this, ObjectStreamClass.this.getProtectionDomains(ObjectStreamClass.this.cons, clazz));
                    ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.getInheritableMethod(clazz, "writeReplace", null, Object.class);
                    ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.getInheritableMethod(clazz, "readResolve", null, Object.class);
                    return null;
                }
            });
        } else {
            this.suid = 0L;
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException invalidClassException) {
            throw new InternalError(invalidClassException);
        }
        if (this.deserializeEx == null) {
            if (this.isEnum) {
                this.deserializeEx = new ExceptionInfo(this.name, "enum type");
            } else if (this.cons == null) {
                this.deserializeEx = new ExceptionInfo(this.name, "no valid constructor");
            }
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getField() != null) continue;
            this.defaultSerializeEx = new ExceptionInfo(this.name, "unmatched serializable field(s) declared");
        }
        this.initialized = true;
    }

    ObjectStreamClass() {
    }

    private ProtectionDomain noPermissionsDomain() {
        Permissions permissions = new Permissions();
        permissions.setReadOnly();
        return new ProtectionDomain(null, permissions);
    }

    private ProtectionDomain[] getProtectionDomains(Constructor<?> constructor, Class<?> clazz) {
        ProtectionDomain[] protectionDomainArray = null;
        if (constructor != null && clazz.getClassLoader() != null && System.getSecurityManager() != null) {
            Class<?> clazz2 = clazz;
            Class<?> clazz3 = constructor.getDeclaringClass();
            HashSet<ProtectionDomain> hashSet = null;
            while (clazz2 != clazz3) {
                ProtectionDomain protectionDomain = clazz2.getProtectionDomain();
                if (protectionDomain != null) {
                    if (hashSet == null) {
                        hashSet = new HashSet<ProtectionDomain>();
                    }
                    hashSet.add(protectionDomain);
                }
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                } else {
                    hashSet.clear();
                }
                hashSet.add(this.noPermissionsDomain());
                break;
            }
            if (hashSet != null) {
                protectionDomainArray = hashSet.toArray(new ProtectionDomain[0]);
            }
        }
        return protectionDomainArray;
    }

    void initProxy(Class<?> clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        ObjectStreamClass objectStreamClass2 = null;
        if (clazz != null) {
            objectStreamClass2 = ObjectStreamClass.lookup(clazz, true);
            if (!objectStreamClass2.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
        }
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass;
        this.isProxy = true;
        this.serializable = true;
        this.suid = 0L;
        this.fields = NO_FIELDS;
        if (objectStreamClass2 != null) {
            this.localDesc = objectStreamClass2;
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
            this.domains = this.localDesc.domains;
            this.cons = this.localDesc.cons;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.initialized = true;
    }

    void initNonProxy(ObjectStreamClass objectStreamClass, Class<?> clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass2) throws InvalidClassException {
        long l = objectStreamClass.getSerialVersionUID();
        ObjectStreamClass objectStreamClass3 = null;
        if (clazz != null) {
            objectStreamClass3 = ObjectStreamClass.lookup(clazz, true);
            if (objectStreamClass3.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (objectStreamClass.isEnum != objectStreamClass3.isEnum) {
                throw new InvalidClassException(objectStreamClass.isEnum ? "cannot bind enum descriptor to a non-enum class" : "cannot bind non-enum descriptor to an enum class");
            }
            if (objectStreamClass.serializable == objectStreamClass3.serializable && !clazz.isArray() && l != objectStreamClass3.getSerialVersionUID()) {
                throw new InvalidClassException(objectStreamClass3.name, "local class incompatible: stream classdesc serialVersionUID = " + l + ", local class serialVersionUID = " + objectStreamClass3.getSerialVersionUID());
            }
            if (!ObjectStreamClass.classNamesEqual(objectStreamClass.name, objectStreamClass3.name)) {
                throw new InvalidClassException(objectStreamClass3.name, "local class name incompatible with stream class name \"" + objectStreamClass.name + "\"");
            }
            if (!objectStreamClass.isEnum) {
                if (objectStreamClass.serializable == objectStreamClass3.serializable && objectStreamClass.externalizable != objectStreamClass3.externalizable) {
                    throw new InvalidClassException(objectStreamClass3.name, "Serializable incompatible with Externalizable");
                }
                if (objectStreamClass.serializable != objectStreamClass3.serializable || objectStreamClass.externalizable != objectStreamClass3.externalizable || !objectStreamClass.serializable && !objectStreamClass.externalizable) {
                    this.deserializeEx = new ExceptionInfo(objectStreamClass3.name, "class invalid for deserialization");
                }
            }
        }
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass2;
        this.name = objectStreamClass.name;
        this.suid = l;
        this.isProxy = false;
        this.isEnum = objectStreamClass.isEnum;
        this.serializable = objectStreamClass.serializable;
        this.externalizable = objectStreamClass.externalizable;
        this.hasBlockExternalData = objectStreamClass.hasBlockExternalData;
        this.hasWriteObjectData = objectStreamClass.hasWriteObjectData;
        this.fields = objectStreamClass.fields;
        this.primDataSize = objectStreamClass.primDataSize;
        this.numObjFields = objectStreamClass.numObjFields;
        if (objectStreamClass3 != null) {
            this.localDesc = objectStreamClass3;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
            this.domains = this.localDesc.domains;
            this.cons = this.localDesc.cons;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.fields = this.fieldRefl.getFields();
        this.initialized = true;
    }

    void readNonProxy(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        this.name = objectInputStream.readUTF();
        this.suid = objectInputStream.readLong();
        this.isProxy = false;
        byte by = objectInputStream.readByte();
        this.hasWriteObjectData = (by & 1) != 0;
        this.hasBlockExternalData = (by & 8) != 0;
        this.externalizable = (by & 4) != 0;
        boolean bl2 = bl = (by & 2) != 0;
        if (this.externalizable && bl) {
            throw new InvalidClassException(this.name, "serializable and externalizable flags conflict");
        }
        this.serializable = this.externalizable || bl;
        boolean bl3 = this.isEnum = (by & 0x10) != 0;
        if (this.isEnum && this.suid != 0L) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero serialVersionUID: " + this.suid);
        }
        int n = objectInputStream.readShort();
        if (this.isEnum && n != 0) {
            throw new InvalidClassException(this.name, "enum descriptor has non-zero field count: " + n);
        }
        this.fields = n > 0 ? new ObjectStreamField[n] : NO_FIELDS;
        for (int i = 0; i < n; ++i) {
            char c = (char)objectInputStream.readByte();
            String string = objectInputStream.readUTF();
            String string2 = c == 'L' || c == '[' ? objectInputStream.readTypeString() : new String(new char[]{c});
            try {
                this.fields[i] = new ObjectStreamField(string, string2, false);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw (IOException)new InvalidClassException(this.name, "invalid descriptor for field " + string).initCause(runtimeException);
            }
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeLong(this.getSerialVersionUID());
        int n2 = 0;
        if (this.externalizable) {
            n2 = (byte)(n2 | 4);
            n = objectOutputStream.getProtocolVersion();
            if (n != 1) {
                n2 = (byte)(n2 | 8);
            }
        } else if (this.serializable) {
            n2 = (byte)(n2 | 2);
        }
        if (this.hasWriteObjectData) {
            n2 = (byte)(n2 | 1);
        }
        if (this.isEnum) {
            n2 = (byte)(n2 | 0x10);
        }
        objectOutputStream.writeByte(n2);
        objectOutputStream.writeShort(this.fields.length);
        for (n = 0; n < this.fields.length; ++n) {
            ObjectStreamField objectStreamField = this.fields[n];
            objectOutputStream.writeByte(objectStreamField.getTypeCode());
            objectOutputStream.writeUTF(objectStreamField.getName());
            if (objectStreamField.isPrimitive()) continue;
            objectOutputStream.writeTypeString(objectStreamField.getTypeString());
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    private final void requireInitialized() {
        if (!this.initialized) {
            throw new InternalError("Unexpected call when not initialized");
        }
    }

    final void checkInitialized() throws InvalidClassException {
        if (!this.initialized) {
            throw new InvalidClassException("Class descriptor should be initialized");
        }
    }

    void checkDeserialize() throws InvalidClassException {
        this.requireInitialized();
        if (this.deserializeEx != null) {
            throw this.deserializeEx.newInvalidClassException();
        }
    }

    void checkSerialize() throws InvalidClassException {
        this.requireInitialized();
        if (this.serializeEx != null) {
            throw this.serializeEx.newInvalidClassException();
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        this.requireInitialized();
        if (this.defaultSerializeEx != null) {
            throw this.defaultSerializeEx.newInvalidClassException();
        }
    }

    ObjectStreamClass getSuperDesc() {
        this.requireInitialized();
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        this.requireInitialized();
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean bl) {
        return bl ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String string, Class<?> clazz) {
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField objectStreamField = this.fields[i];
            if (!objectStreamField.getName().equals(string)) continue;
            if (clazz == null || clazz == Object.class && !objectStreamField.isPrimitive()) {
                return objectStreamField;
            }
            Class<?> clazz2 = objectStreamField.getType();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            return objectStreamField;
        }
        return null;
    }

    boolean isProxy() {
        this.requireInitialized();
        return this.isProxy;
    }

    boolean isEnum() {
        this.requireInitialized();
        return this.isEnum;
    }

    boolean isExternalizable() {
        this.requireInitialized();
        return this.externalizable;
    }

    boolean isSerializable() {
        this.requireInitialized();
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        this.requireInitialized();
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        this.requireInitialized();
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        this.requireInitialized();
        return this.cons != null;
    }

    boolean hasWriteObjectMethod() {
        this.requireInitialized();
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        this.requireInitialized();
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        this.requireInitialized();
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        this.requireInitialized();
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        this.requireInitialized();
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.cons != null) {
            try {
                if (this.domains == null || this.domains.length == 0) {
                    return this.cons.newInstance(new Object[0]);
                }
                JavaSecurityAccess javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
                PrivilegedAction<Object> privilegedAction = () -> {
                    try {
                        return this.cons.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                        throw new UndeclaredThrowableException(reflectiveOperationException);
                    }
                };
                try {
                    return javaSecurityAccess.doIntersectionPrivilege(privilegedAction, AccessController.getContext(), new AccessControlContext(this.domains));
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    Throwable throwable = undeclaredThrowableException.getCause();
                    if (throwable instanceof InstantiationException) {
                        throw (InstantiationException)throwable;
                    }
                    if (throwable instanceof InvocationTargetException) {
                        throw (InvocationTargetException)throwable;
                    }
                    if (throwable instanceof IllegalAccessException) {
                        throw (IllegalAccessException)throwable;
                    }
                    throw undeclaredThrowableException;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
            catch (InstantiationError instantiationError) {
                InstantiationException instantiationException = new InstantiationException();
                instantiationException.initCause(instantiationError);
                throw instantiationException;
            }
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object object, ObjectOutputStream objectOutputStream) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(object, objectOutputStream);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object object, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(object, objectInputStream);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object object) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(object, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object object) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(object, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object object) throws IOException, UnsupportedOperationException {
        this.requireInitialized();
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(object, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Class<?> clazz;
        ArrayList<ClassDataSlot> arrayList = new ArrayList<ClassDataSlot>();
        Class<?> clazz2 = this.cl;
        for (clazz = this.cl; clazz != null && Serializable.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
        }
        HashSet<String> hashSet = new HashSet<String>(3);
        Serializable serializable = this;
        while (serializable != null) {
            Class<?> clazz3;
            if (hashSet.contains(((ObjectStreamClass)serializable).name)) {
                throw new InvalidClassException("Circular reference.");
            }
            hashSet.add(((ObjectStreamClass)serializable).name);
            String string = ((ObjectStreamClass)serializable).cl != null ? ((ObjectStreamClass)serializable).cl.getName() : ((ObjectStreamClass)serializable).name;
            Class<?> clazz4 = null;
            for (clazz3 = clazz2; clazz3 != clazz; clazz3 = clazz3.getSuperclass()) {
                if (!string.equals(clazz3.getName())) continue;
                clazz4 = clazz3;
                break;
            }
            if (clazz4 != null) {
                for (clazz3 = clazz2; clazz3 != clazz4; clazz3 = clazz3.getSuperclass()) {
                    arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(clazz3, true), false));
                }
                clazz2 = clazz4.getSuperclass();
            }
            arrayList.add(new ClassDataSlot(super.getVariantFor(clazz4), true));
            serializable = ((ObjectStreamClass)serializable).superDesc;
        }
        for (serializable = clazz2; serializable != clazz; serializable = ((Class)serializable).getSuperclass()) {
            arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(serializable, true), false));
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new ClassDataSlot[arrayList.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.getPrimFieldValues(object, byArray);
    }

    void setPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.setPrimFieldValues(object, byArray);
    }

    void getObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.getObjFieldValues(object, objectArray);
    }

    void setObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.setObjFieldValues(object, objectArray);
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int n = -1;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField objectStreamField = this.fields[i];
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    objectStreamField.setOffset(this.primDataSize++);
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    objectStreamField.setOffset(this.numObjFields++);
                    if (n != -1) continue block7;
                    n = i;
                    continue block7;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (n != -1 && n + this.numObjFields != this.fields.length) {
            throw new InvalidClassException(this.name, "illegal field order");
        }
    }

    private ObjectStreamClass getVariantFor(Class<?> clazz) throws InvalidClassException {
        if (this.cl == clazz) {
            return this;
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        if (this.isProxy) {
            objectStreamClass.initProxy(clazz, null, this.superDesc);
        } else {
            objectStreamClass.initNonProxy(this, clazz, null, this.superDesc);
        }
        return objectStreamClass;
    }

    private static Constructor<?> getExternalizableConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(null);
            constructor.setAccessible(true);
            return (constructor.getModifiers() & 1) != 0 ? constructor : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean superHasAccessibleConstructor(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        assert (Serializable.class.isAssignableFrom(clazz));
        assert (clazz2 != null);
        if (ObjectStreamClass.packageEquals(clazz, clazz2)) {
            for (Constructor<?> constructor : clazz2.getDeclaredConstructors()) {
                if ((constructor.getModifiers() & 2) != 0) continue;
                return true;
            }
            return false;
        }
        if ((clazz2.getModifiers() & 5) == 0) {
            return false;
        }
        for (Constructor<?> constructor : clazz2.getDeclaredConstructors()) {
            if ((constructor.getModifiers() & 5) == 0) continue;
            return true;
        }
        return false;
    }

    private static Constructor<?> getSerializableConstructor(Class<?> clazz) {
        GenericDeclaration genericDeclaration;
        Class<?> clazz2 = clazz;
        while (Serializable.class.isAssignableFrom(clazz2)) {
            genericDeclaration = clazz2;
            if ((clazz2 = clazz2.getSuperclass()) != null && (disableSerialConstructorChecks || ObjectStreamClass.superHasAccessibleConstructor(genericDeclaration))) continue;
            return null;
        }
        try {
            genericDeclaration = clazz2.getDeclaredConstructor(null);
            int n = ((Constructor)genericDeclaration).getModifiers();
            if ((n & 2) != 0 || (n & 5) == 0 && !ObjectStreamClass.packageEquals(clazz, clazz2)) {
                return null;
            }
            genericDeclaration = reflFactory.newConstructorForSerialization(clazz, (Constructor<?>)genericDeclaration);
            ((AccessibleObject)((Object)genericDeclaration)).setAccessible(true);
            return genericDeclaration;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getInheritableMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2) {
        Class<?> clazz3;
        Method method = null;
        for (clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        method.setAccessible(true);
        int n = method.getModifiers();
        if ((n & 0x408) != 0) {
            return null;
        }
        if ((n & 5) != 0) {
            return method;
        }
        if ((n & 2) != 0) {
            return clazz == clazz3 ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static Method getPrivateMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            int n = method.getModifiers();
            return method.getReturnType() == clazz2 && (n & 8) == 0 && (n & 2) != 0 ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean packageEquals(Class<?> clazz, Class<?> clazz2) {
        return clazz.getClassLoader() == clazz2.getClassLoader() && ObjectStreamClass.getPackageName(clazz).equals(ObjectStreamClass.getPackageName(clazz2));
    }

    private static String getPackageName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(91);
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        return (n = string.lastIndexOf(46)) >= 0 ? string.substring(0, n) : "";
    }

    private static boolean classNamesEqual(String string, String string2) {
        string = string.substring(string.lastIndexOf(46) + 1);
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        return string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClassSignature(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        while (clazz.isArray()) {
            stringBuilder.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                stringBuilder.append('I');
                return stringBuilder.toString();
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append('B');
                return stringBuilder.toString();
            } else if (clazz == Long.TYPE) {
                stringBuilder.append('J');
                return stringBuilder.toString();
            } else if (clazz == Float.TYPE) {
                stringBuilder.append('F');
                return stringBuilder.toString();
            } else if (clazz == Double.TYPE) {
                stringBuilder.append('D');
                return stringBuilder.toString();
            } else if (clazz == Short.TYPE) {
                stringBuilder.append('S');
                return stringBuilder.toString();
            } else if (clazz == Character.TYPE) {
                stringBuilder.append('C');
                return stringBuilder.toString();
            } else if (clazz == Boolean.TYPE) {
                stringBuilder.append('Z');
                return stringBuilder.toString();
            } else {
                if (clazz != Void.TYPE) throw new InternalError();
                stringBuilder.append('V');
            }
            return stringBuilder.toString();
        } else {
            stringBuilder.append('L' + clazz.getName().replace('.', '/') + ';');
        }
        return stringBuilder.toString();
    }

    private static String getMethodSignature(Class<?>[] classArray, Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(ObjectStreamClass.getClassSignature(classArray[i]));
        }
        stringBuilder.append(')');
        stringBuilder.append(ObjectStreamClass.getClassSignature(clazz));
        return stringBuilder.toString();
    }

    private static void throwMiscException(Throwable throwable) throws IOException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IOException iOException = new IOException("unexpected exception type");
        iOException.initCause(throwable);
        throw iOException;
    }

    private static ObjectStreamField[] getSerialFields(Class<?> clazz) throws InvalidClassException {
        Object[] objectArray;
        if (Serializable.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && !Proxy.isProxyClass(clazz) && !clazz.isInterface()) {
            objectArray = ObjectStreamClass.getDeclaredSerialFields(clazz);
            if (objectArray == null) {
                objectArray = ObjectStreamClass.getDefaultSerialFields(clazz);
            }
            Arrays.sort(objectArray);
        } else {
            objectArray = NO_FIELDS;
        }
        return objectArray;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class<?> clazz) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray;
        ObjectStreamField[] objectStreamFieldArray2 = null;
        try {
            objectStreamFieldArray = clazz.getDeclaredField("serialPersistentFields");
            int n = 26;
            if ((objectStreamFieldArray.getModifiers() & n) == n) {
                objectStreamFieldArray.setAccessible(true);
                objectStreamFieldArray2 = (ObjectStreamField[])objectStreamFieldArray.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        if (objectStreamFieldArray2.length == 0) {
            return NO_FIELDS;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        HashSet<String> hashSet = new HashSet<String>(objectStreamFieldArray2.length);
        for (int i = 0; i < objectStreamFieldArray2.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray2[i];
            String string = objectStreamField.getName();
            if (hashSet.contains(string)) {
                throw new InvalidClassException("multiple serializable fields named " + string);
            }
            hashSet.add(string);
            try {
                Field field = clazz.getDeclaredField(string);
                if (field.getType() == objectStreamField.getType() && (field.getModifiers() & 8) == 0) {
                    objectStreamFieldArray[i] = new ObjectStreamField(field, objectStreamField.isUnshared(), true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (objectStreamFieldArray[i] != null) continue;
            objectStreamFieldArray[i] = new ObjectStreamField(string, objectStreamField.getType(), objectStreamField.isUnshared());
        }
        return objectStreamFieldArray;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class<?> clazz) {
        int n;
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<ObjectStreamField> arrayList = new ArrayList<ObjectStreamField>();
        int n2 = 136;
        for (n = 0; n < fieldArray.length; ++n) {
            if ((fieldArray[n].getModifiers() & n2) != 0) continue;
            arrayList.add(new ObjectStreamField(fieldArray[n], false, true));
        }
        n = arrayList.size();
        return n == 0 ? NO_FIELDS : arrayList.toArray(new ObjectStreamField[n]);
    }

    private static Long getDeclaredSUID(Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            int n = 24;
            if ((field.getModifiers() & n) == n) {
                field.setAccessible(true);
                return field.getLong(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long computeDefaultSUID(Class<?> clazz) {
        if (!Serializable.class.isAssignableFrom(clazz) || Proxy.isProxyClass(clazz)) {
            return 0L;
        }
        try {
            int n;
            int n2;
            MemberSignature[] memberSignatureArray;
            int n3;
            Object[] objectArray;
            AnnotatedElement[] annotatedElementArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n4 = clazz.getModifiers() & 0x611;
            Method[] methodArray = clazz.getDeclaredMethods();
            if ((n4 & 0x200) != 0) {
                n4 = methodArray.length > 0 ? n4 | 0x400 : n4 & 0xFFFFFBFF;
            }
            dataOutputStream.writeInt(n4);
            if (!clazz.isArray()) {
                annotatedElementArray = clazz.getInterfaces();
                objectArray = new String[annotatedElementArray.length];
                for (n3 = 0; n3 < annotatedElementArray.length; ++n3) {
                    objectArray[n3] = ((Class)annotatedElementArray[n3]).getName();
                }
                Arrays.sort(objectArray);
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    dataOutputStream.writeUTF((String)objectArray[n3]);
                }
            }
            annotatedElementArray = clazz.getDeclaredFields();
            objectArray = new MemberSignature[annotatedElementArray.length];
            for (n3 = 0; n3 < annotatedElementArray.length; ++n3) {
                objectArray[n3] = new MemberSignature((Field)annotatedElementArray[n3]);
            }
            Arrays.sort(objectArray, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature memberSignature, MemberSignature memberSignature2) {
                    return memberSignature.name.compareTo(memberSignature2.name);
                }
            });
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                memberSignatureArray = objectArray[n3];
                n2 = memberSignatureArray.member.getModifiers() & 0xDF;
                if ((n2 & 2) != 0 && (n2 & 0x88) != 0) continue;
                dataOutputStream.writeUTF(memberSignatureArray.name);
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(memberSignatureArray.signature);
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            memberSignatureArray = new MemberSignature[constructorArray.length];
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                memberSignatureArray[n2] = new MemberSignature(constructorArray[n2]);
            }
            Arrays.sort(memberSignatureArray, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature memberSignature, MemberSignature memberSignature2) {
                    return memberSignature.signature.compareTo(memberSignature2.signature);
                }
            });
            for (n2 = 0; n2 < memberSignatureArray.length; ++n2) {
                MemberSignature memberSignature = memberSignatureArray[n2];
                int n5 = memberSignature.member.getModifiers() & 0xD3F;
                if ((n5 & 2) != 0) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n5);
                dataOutputStream.writeUTF(memberSignature.signature.replace('/', '.'));
            }
            MemberSignature[] memberSignatureArray2 = new MemberSignature[methodArray.length];
            for (n = 0; n < methodArray.length; ++n) {
                memberSignatureArray2[n] = new MemberSignature(methodArray[n]);
            }
            Arrays.sort(memberSignatureArray2, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature memberSignature, MemberSignature memberSignature2) {
                    int n = memberSignature.name.compareTo(memberSignature2.name);
                    if (n == 0) {
                        n = memberSignature.signature.compareTo(memberSignature2.signature);
                    }
                    return n;
                }
            });
            for (n = 0; n < memberSignatureArray2.length; ++n) {
                MemberSignature memberSignature = memberSignatureArray2[n];
                int n6 = memberSignature.member.getModifiers() & 0xD3F;
                if ((n6 & 2) != 0) continue;
                dataOutputStream.writeUTF(memberSignature.name);
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeUTF(memberSignature.signature.replace('/', '.'));
            }
            dataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l = 0L;
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
            return l;
        }
        catch (IOException iOException) {
            throw new InternalError(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
    }

    private static native boolean hasStaticInitializer(Class<?> var0);

    private static FieldReflector getReflector(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        Class<?> clazz = objectStreamClass != null && objectStreamFieldArray.length > 0 ? objectStreamClass.cl : null;
        ObjectStreamClass.processQueue(Caches.reflectorsQueue, Caches.reflectors);
        FieldReflectorKey fieldReflectorKey = new FieldReflectorKey(clazz, objectStreamFieldArray, Caches.reflectorsQueue);
        Reference reference = (Reference)Caches.reflectors.get(fieldReflectorKey);
        Object object = null;
        if (reference != null) {
            object = reference.get();
        }
        EntryFuture entryFuture = null;
        if (object == null) {
            EntryFuture entryFuture2 = new EntryFuture();
            SoftReference<EntryFuture> softReference = new SoftReference<EntryFuture>(entryFuture2);
            do {
                if (reference != null) {
                    Caches.reflectors.remove(fieldReflectorKey, reference);
                }
                if ((reference = (Reference)Caches.reflectors.putIfAbsent(fieldReflectorKey, softReference)) == null) continue;
                object = reference.get();
            } while (reference != null && object == null);
            if (object == null) {
                entryFuture = entryFuture2;
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new FieldReflector(ObjectStreamClass.matchFields(objectStreamFieldArray, objectStreamClass));
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            Caches.reflectors.put(fieldReflectorKey, new SoftReference<Object>(object));
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof InvalidClassException) {
            throw (InvalidClassException)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray2 = objectStreamClass != null ? objectStreamClass.fields : NO_FIELDS;
        ObjectStreamField[] objectStreamFieldArray3 = new ObjectStreamField[objectStreamFieldArray.length];
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ObjectStreamField objectStreamField2 = null;
            for (int j = 0; j < objectStreamFieldArray2.length; ++j) {
                ObjectStreamField objectStreamField3 = objectStreamFieldArray2[j];
                if (!objectStreamField.getName().equals(objectStreamField3.getName())) continue;
                if ((objectStreamField.isPrimitive() || objectStreamField3.isPrimitive()) && objectStreamField.getTypeCode() != objectStreamField3.getTypeCode()) {
                    throw new InvalidClassException(objectStreamClass.name, "incompatible types for field " + objectStreamField.getName());
                }
                objectStreamField2 = objectStreamField3.getField() != null ? new ObjectStreamField(objectStreamField3.getField(), objectStreamField3.isUnshared(), false) : new ObjectStreamField(objectStreamField3.getName(), objectStreamField3.getSignature(), objectStreamField3.isUnshared());
            }
            if (objectStreamField2 == null) {
                objectStreamField2 = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getSignature(), false);
            }
            objectStreamField2.setOffset(objectStreamField.getOffset());
            objectStreamFieldArray3[i] = objectStreamField2;
        }
        return objectStreamFieldArray3;
    }

    static void processQueue(ReferenceQueue<Class<?>> referenceQueue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> concurrentMap) {
        Reference<Class<?>> reference;
        while ((reference = referenceQueue.poll()) != null) {
            concurrentMap.remove(reference);
        }
    }

    static /* synthetic */ ObjectStreamField[] access$602(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static /* synthetic */ ProtectionDomain[] access$2102(ObjectStreamClass objectStreamClass, ProtectionDomain[] protectionDomainArray) {
        objectStreamClass.domains = protectionDomainArray;
        return protectionDomainArray;
    }

    static {
        ObjectStreamClass.initNative();
    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Reference<?>> localDescs = new ConcurrentHashMap();
        static final ConcurrentMap<FieldReflectorKey, Reference<?>> reflectors = new ConcurrentHashMap();
        private static final ReferenceQueue<Class<?>> localDescsQueue = new ReferenceQueue();
        private static final ReferenceQueue<Class<?>> reflectorsQueue = new ReferenceQueue();

        private Caches() {
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass objectStreamClass, boolean bl) {
            this.desc = objectStreamClass;
            this.hasData = bl;
        }
    }

    private static class EntryFuture {
        private static final Object unset = new Object();
        private final Thread owner = Thread.currentThread();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized boolean set(Object object) {
            if (this.entry != unset) {
                return false;
            }
            this.entry = object;
            this.notifyAll();
            return true;
        }

        synchronized Object get() {
            boolean bl = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }

        Thread getOwner() {
            return this.owner;
        }
    }

    private static class ExceptionInfo {
        private final String className;
        private final String message;

        ExceptionInfo(String string, String string2) {
            this.className = string;
            this.message = string2;
        }

        InvalidClassException newInvalidClassException() {
            return new InvalidClassException(this.className, this.message);
        }
    }

    private static class FieldReflector {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final long[] readKeys;
        private final long[] writeKeys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class<?>[] types;

        FieldReflector(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            int n = objectStreamFieldArray.length;
            this.readKeys = new long[n];
            this.writeKeys = new long[n];
            this.offsets = new int[n];
            this.typeCodes = new char[n];
            ArrayList arrayList = new ArrayList();
            HashSet<Long> hashSet = new HashSet<Long>();
            for (int i = 0; i < n; ++i) {
                long l;
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                Field field = objectStreamField.getField();
                this.readKeys[i] = l = field != null ? unsafe.objectFieldOffset(field) : -1L;
                this.writeKeys[i] = hashSet.add(l) ? l : -1L;
                this.offsets[i] = objectStreamField.getOffset();
                this.typeCodes[i] = objectStreamField.getTypeCode();
                if (objectStreamField.isPrimitive()) continue;
                arrayList.add(field != null ? field.getType() : null);
            }
            this.types = arrayList.toArray(new Class[arrayList.size()]);
            this.numPrimFields = n - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long l = this.readKeys[i];
                int n = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        Bits.putBoolean(byArray, n, unsafe.getBoolean(object, l));
                        continue block10;
                    }
                    case 'B': {
                        byArray[n] = unsafe.getByte(object, l);
                        continue block10;
                    }
                    case 'C': {
                        Bits.putChar(byArray, n, unsafe.getChar(object, l));
                        continue block10;
                    }
                    case 'S': {
                        Bits.putShort(byArray, n, unsafe.getShort(object, l));
                        continue block10;
                    }
                    case 'I': {
                        Bits.putInt(byArray, n, unsafe.getInt(object, l));
                        continue block10;
                    }
                    case 'F': {
                        Bits.putFloat(byArray, n, unsafe.getFloat(object, l));
                        continue block10;
                    }
                    case 'J': {
                        Bits.putLong(byArray, n, unsafe.getLong(object, l));
                        continue block10;
                    }
                    case 'D': {
                        Bits.putDouble(byArray, n, unsafe.getDouble(object, l));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long l = this.writeKeys[i];
                if (l == -1L) continue;
                int n = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        unsafe.putBoolean(object, l, Bits.getBoolean(byArray, n));
                        continue block10;
                    }
                    case 'B': {
                        unsafe.putByte(object, l, byArray[n]);
                        continue block10;
                    }
                    case 'C': {
                        unsafe.putChar(object, l, Bits.getChar(byArray, n));
                        continue block10;
                    }
                    case 'S': {
                        unsafe.putShort(object, l, Bits.getShort(byArray, n));
                        continue block10;
                    }
                    case 'I': {
                        unsafe.putInt(object, l, Bits.getInt(byArray, n));
                        continue block10;
                    }
                    case 'F': {
                        unsafe.putFloat(object, l, Bits.getFloat(byArray, n));
                        continue block10;
                    }
                    case 'J': {
                        unsafe.putLong(object, l, Bits.getLong(byArray, n));
                        continue block10;
                    }
                    case 'D': {
                        unsafe.putDouble(object, l, Bits.getDouble(byArray, n));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void getObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        objectArray[this.offsets[i]] = unsafe.getObject(object, this.readKeys[i]);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                long l = this.writeKeys[i];
                if (l == -1L) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object object2 = objectArray[this.offsets[i]];
                        if (object2 != null && !this.types[i - this.numPrimFields].isInstance(object2)) {
                            Field field = this.fields[i].getField();
                            throw new ClassCastException("cannot assign instance of " + object2.getClass().getName() + " to field " + field.getDeclaringClass().getName() + "." + field.getName() + " of type " + field.getType().getName() + " in instance of " + object.getClass().getName());
                        }
                        unsafe.putObject(object, l, object2);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }
    }

    private static class FieldReflectorKey
    extends WeakReference<Class<?>> {
        private final String[] sigs;
        private final int hash;
        private final boolean nullClass;

        FieldReflectorKey(Class<?> clazz, ObjectStreamField[] objectStreamFieldArray, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.nullClass = clazz == null;
            this.sigs = new String[2 * objectStreamFieldArray.length];
            int n = 0;
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                this.sigs[n++] = objectStreamField.getName();
                this.sigs[n++] = objectStreamField.getSignature();
            }
            this.hash = System.identityHashCode(clazz) + Arrays.hashCode(this.sigs);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FieldReflectorKey) {
                Class clazz;
                FieldReflectorKey fieldReflectorKey = (FieldReflectorKey)object;
                return (this.nullClass ? fieldReflectorKey.nullClass : (clazz = (Class)this.get()) != null && clazz == fieldReflectorKey.get()) && Arrays.equals(this.sigs, fieldReflectorKey.sigs);
            }
            return false;
        }
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamClass.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor<?> constructor) {
            this.member = constructor;
            this.name = constructor.getName();
            this.signature = ObjectStreamClass.getMethodSignature(constructor.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method method) {
            this.member = method;
            this.name = method.getName();
            this.signature = ObjectStreamClass.getMethodSignature(method.getParameterTypes(), method.getReturnType());
        }
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> clazz, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.hash = System.identityHashCode(clazz);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof WeakClassKey) {
                Object t = this.get();
                return t != null && t == ((WeakClassKey)object).get();
            }
            return false;
        }
    }
}

